setDefaultTab("PVP")
UI.Separator()
dofile('vBot/_spellsData.lua')

local panelName = "smartUE"

if not storage[panelName] then
  storage[panelName] = {
    areaRuneId = 0,
    singleRuneId = 0
  }
end

local ueConfig = storage[panelName]

local ui = setupUI([[
Panel
  height: 19

  Button
    id: setup
    anchors.left: parent.left
    anchors.right: parent.right
    height: 17
    text: Setup
]])
ui:setId(panelName)

-- Verifica se o detector de vocação está carregado
if not PlayerVocation or not PlayerVocation.detected then
end

-- FUNÇÃO PARA EXECUTAR MAGIA POR ID
local function executeSpellById(spellId)
    if not PlayerVocation or not PlayerVocation.detected then
        return false
    end

    local vocationName = PlayerVocation.name:lower()
    if not availableSpells[vocationName] then
        return false
    end

    local target = g_game.getAttackingCreature()
    if not target then
        return false
    end

    -- Procura a magia em todas as categorias
    for category, spells in pairs(availableSpells[vocationName]) do
        for _, spell in ipairs(spells) do
            if spell.id == spellId then

                -- 🔒 SOMENTE se a spell selecionada for Runa Configurada
                if spell.id == "rc_area" and category == "area" then
                    if ueConfig.areaRuneId ~= 0 then
                        useWith(ueConfig.areaRuneId, target)
                        return true
                    end
                    return false
                end

                if spell.id == "rc_single" and category == "single" then
                    if ueConfig.singleRuneId ~= 0 then
                        useWith(ueConfig.singleRuneId, target)
                        return true
                    end
                    return false
                end

                -- ⚠️ QUALQUER OUTRA SPELL IGNORA O SETUP
                if spell.isRune then
                    useWith(spell.runeId, target)
                    return true
                end

                -- magia normal
                say(spell.name)
                return true
            end
        end
    end

    return false
end



-- ARMAZENAR REFERÊNCIAS DOS MACROS DAS MAGIAS
local areaMacros = {}
local singleMacros = {}

-- FUNÇÃO PARA MOSTRAR ESTADO DE TODOS OS BOTÕES (DEBUG)
local function debugAllButtons()
    for i, macroInfo in ipairs(areaMacros) do
        local status = macroInfo.macro:isOn() and "LIGADO" or "DESLIGADO"
    end
    for i, macroInfo in ipairs(singleMacros) do
        local status = macroInfo.macro:isOn() and "LIGADO" or "DESLIGADO"
    end
end

-- FUNÇÃO PARA ENCONTRAR SPELL ATIVO
local function findActiveSpell(macroList, category)    
    debugAllButtons()
    
    for i, macroInfo in ipairs(macroList) do
        local isActive = macroInfo.macro:isOn()
        if isActive then
            return macroInfo.spellId, macroInfo.spellName
        end
    end
    return nil, nil
end

local function turnOffOtherMacros(macros, currentMacro)
    for _, data in ipairs(macros) do
        if data.macro ~= currentMacro and data.macro:isOn() then
            data.macro:setOn(false)
        end
    end
end


local function createVocationButtons()
    if not PlayerVocation or not PlayerVocation.detected then
        UI.Label("Waiting for vocation detection...")
        return
    end

    local vocationName = PlayerVocation.name:lower()
    if not availableSpells[vocationName] then
        UI.Label("Vocation not supported")
        return
    end

    UI.Label("Vocation - " .. PlayerVocation.name)

    -- =========================
    -- AREA SPELLS
    -- =========================
    if availableSpells[vocationName].area then
        local label = UI.Label("Area Spells")
        label:setColor('#00FF7F')

        for _, spell in ipairs(availableSpells[vocationName].area) do
            local spellMacro = macro(500, spell.name, function()
                activeAreaSpellId = spell.id
                turnOffOtherMacros(areaMacros, spellMacro)
            end)

            table.insert(areaMacros, {
                macro = spellMacro,
                spellId = spell.id,
                spellName = spell.name
            })
        end
    end

    UI.Separator()

    -- =========================
    -- SINGLE TARGET SPELLS
    -- =========================
    if availableSpells[vocationName].single then
        local label = UI.Label("Single Target Spells")
        label:setColor('#a268ffff')

        for _, spell in ipairs(availableSpells[vocationName].single) do
            local spellMacro = macro(500, spell.name, function()
                activeSingleSpellId = spell.id
                turnOffOtherMacros(singleMacros, spellMacro)
            end)

            table.insert(singleMacros, {
                macro = spellMacro,
                spellId = spell.id,
                spellName = spell.name
            })
        end
    end
end


-- Criar botões primeiro
createVocationButtons()

UI.Separator()
local label = UI.Label("MAIN CONTROLLERS")
label:setColor('#74ffffff')


-- REFERÊNCIAS DOS MACROS PRINCIPAIS
local macroSafeUE, macroNotSafeUE, macroSingleTarget

-- FUNÇÃO PARA DESLIGAR OUTROS MACROS PRINCIPAIS
local function disableOtherMainMacros(currentMacro)
    if currentMacro ~= macroSafeUE and macroSafeUE then
        -- macroSafeUE:setOn(false)
    end
    if currentMacro ~= macroNotSafeUE and macroNotSafeUE then
        -- macroNotSafeUE:setOn(false)
    end
    if currentMacro ~= macroSingleTarget and macroSingleTarget then
        -- macroSingleTarget:setOn(false)
    end
end

local function executeUE(spellId, category)
    local target = g_game.getAttackingCreature()
    if not target then return false end

    -- 🔒 Usa runa configurada SOMENTE se a spell ativa for rc_*
    if spellId == "rc_area" and category == "area" then
        if ueConfig.areaRuneId ~= 0 then
            useWith(ueConfig.areaRuneId, target)
            return true
        end
        return false
    end

    if spellId == "rc_single" and category == "single" then
        if ueConfig.singleRuneId ~= 0 then
            useWith(ueConfig.singleRuneId, target)
            return true
        end
        return false
    end

    -- ⚠️ QUALQUER OUTRA SPELL IGNORA COMPLETAMENTE O SETUP
    return executeSpellById(spellId)
end



-- MACROS PRINCIPAIS
macroSafeUE = macro(1000, "Anti RED - ON", function()
    local target = g_game.getAttackingCreature()
    if not target then
        return
    end
    if manapercent() < 30 then
        return
    end

    if activeAreaSpellId then
        local safeCheck = isSafe(15)
        if safeCheck then
            executeUE(activeAreaSpellId, "area")
        else
            if activeSingleSpellId then
                executeUE(activeSingleSpellId, "single")
            end
        end
    end
end)

-- macroSafeUE:setOn(false)

-- Callback para quando o macro Safe é ligado/desligado
macroSafeUE.onValueChange = function(widget, value)
    if value then
        disableOtherMainMacros(macroSafeUE)
    end
end

macroNotSafeUE = macro(1000, "Anti RED - OFF", function()
    local target = g_game.getAttackingCreature()
    if not target then
        return
    end

    if activeAreaSpellId then
        executeUE(activeAreaSpellId, "area")
    end
end)


-- macroNotSafeUE:setOn(false)

-- Callback para quando o macro Not Safe é ligado/desligado
macroNotSafeUE.onValueChange = function(widget, value)
    if value then
        disableOtherMainMacros(macroNotSafeUE)
    end
end

macroSingleTarget = macro(1000, "Single target", function()
    if not activeSingleSpellId then
        return
    end

    local target = g_game.getAttackingCreature()
    if not target then
        return
    end

    executeUE(activeSingleSpellId, "single")
end)


-- macroSingleTarget:setOn(false)

-- Callback para quando o macro Single Target é ligado/desligado
macroSingleTarget.onValueChange = function(widget, value)
    if value then
        disableOtherMainMacros(macroSingleTarget)
    end
end

schedule(1000, function()
    if PlayerVocation and PlayerVocation.detected then
    end
end)

local rootWidget = g_ui.getRootWidget()
local ueWindow

if rootWidget then
  ueWindow = UI.createWindow('SmartUEWindow', rootWidget)
  ueWindow:hide()

  ueWindow.closeButton.onClick = function()
    ueWindow:hide()
  end

    -- busca correta dos widgets (hierarquia OTUI)
    local runesPanel  = ueWindow:getChildById('runesPanel')
    local areaPanel   = runesPanel:getChildById('areaPanel')
    local singlePanel = runesPanel:getChildById('singlePanel')

    local areaRune   = areaPanel:getChildById('areaRune')
    local singleRune = singlePanel:getChildById('singleRune')

    -- Area Rune
    areaRune.onItemChange = function(widget)
    ueConfig.areaRuneId = widget:getItemId()
    end
    areaRune:setItemId(ueConfig.areaRuneId)

    -- Single Target Rune
    singleRune.onItemChange = function(widget)
    ueConfig.singleRuneId = widget:getItemId()
    end
    singleRune:setItemId(ueConfig.singleRuneId)

end

ui.setup.onClick = function()
  ueWindow:show()
  ueWindow:raise()
  ueWindow:focus()
end


UI.Separator()