setDefaultTab("Tools")

if type(storage.pickUp) ~= "table" then
  storage.pickUp = {3725, 3723}
end

if type(storage.containerpickUp) ~= "table" then
  storage.containerpickUp = {5926}
end

-- Painel superior com botão de ativação e editar na mesma linha
local ui = setupUI([[
Panel
  height: 19

  BotSwitch
    id: toggle
    anchors.top: parent.top
    anchors.left: parent.left
    text-align: center
    width: 130
    !text: tr('Rataria Forte')

  Button
    id: edit
    anchors.top: prev.top
    anchors.left: prev.right
    anchors.right: parent.right
    margin-left: 3
    height: 17
    text: Edit
]])

-- Painel de edição
local editPanel = setupUI([[
Panel
  height: 170

  Label
    anchors.top: parent.top
    anchors.left: parent.left
    anchors.right: parent.right
    margin-top: 5
    text-align: center
    text: Itens de coleta:

  BotContainer
    id: pickUpContainer
    anchors.top: prev.bottom
    anchors.left: parent.left
    anchors.right: parent.right
    height: 60

  Label
    anchors.top: prev.bottom
    anchors.left: parent.left
    anchors.right: parent.right
    margin-top: 5
    text-align: center
    text: BackPack:

  BotContainer
    id: containerpickUpContainer
    anchors.top: prev.bottom
    anchors.left: parent.left
    anchors.right: parent.right
    height: 60
]])
editPanel:hide()

-- Inicialização dos containers
-- editPanel.pickUpContainer:setItems(storage.pickUp)
-- editPanel.containerpickUpContainer:setItems(storage.containerpickUp)

UI.Container(function()
  storage.pickUp = editPanel.pickUpContainer:getItems()
end, true, nil, editPanel.pickUpContainer)
UI.Container(function()
  storage.containerpickUp = editPanel.containerpickUpContainer:getItems()
end, true, nil, editPanel.containerpickUpContainer)

-- Alternador liga/desliga
if storage.catarEnabled == nil then storage.catarEnabled = true end
ui.toggle:setOn(storage.catarEnabled)
ui.toggle.onClick = function()
  storage.catarEnabled = not storage.catarEnabled
  ui.toggle:setOn(storage.catarEnabled)
end

-- Botão Edit
local showEdit = false
ui.edit.onClick = function()
  showEdit = not showEdit
  if showEdit then
    editPanel:show()
  else
    editPanel:hide()
  end
end

local CheckPOS = 10

-- Macro de coleta
rat = macro(500, function()
  if not storage.catarEnabled then return end
  if not storage.pickUp[1] then return end
  for x = -CheckPOS, CheckPOS do
    for y = -CheckPOS, CheckPOS do
      local tile = g_map.getTile({x = posx() + x, y = posy() + y, z = posz()})
      if tile then
        local things = tile:getThings()
        for _, item in pairs(things) do
          for _, catar in pairs(storage.pickUp) do
            if table.find(catar, item:getId()) then
              local containers = getContainers()
              for _, container in pairs(containers) do            
                for _, guardar in pairs(storage.containerpickUp) do
                  if table.find(guardar, container:getContainerItem():getId()) then
                    g_game.move(item, container:getSlotPosition(container:getItemsCount()), item:getCount())
                    delay(100)               
                  end  
                end
              end
            end
          end
        end
      end
    end
  end
end, "rataria")