local toolsTab = addTab("Tools")
local caveTab = addTab("cave")
local pvpTab = addTab("PVP")
local hpTab = addTab("HP")
function AddScrolls(panelName, parent)
  if not parent then
    parent = panel
  end
 
  local ui = setupUI([[
Panel
  height: 50
  margin-top: 2

  BotItem
    id: bpId
    anchors.left: parent.left
    anchors.top: parent.top

  BotLabel
    id: title
    anchors.left: bpId.right
    anchors.right: parent.right
    anchors.top: bpId.verticalCenter
    text-align: center

  HorizontalScrollBar
    id: scroll1
    anchors.left: parent.left
    anchors.right: parent.horizontalCenter
    anchors.top: bpId.bottom
    margin-right: 2
    margin-top: 2
    minimum: 0
    maximum: 100
    step: 1
    
  HorizontalScrollBar
    id: scroll2
    anchors.left: parent.horizontalCenter
    anchors.right: parent.right
    anchors.top: prev.top
    margin-left: 2
    minimum: 0
    maximum: 100
    step: 1    
  ]], parent)
  ui:setId(panelName)
  if not storage[panelName] or not storage[panelName].bpId then
    storage[panelName] = {
      min = 60,
      max = 90,
      bpId = 2854
    }
  end
  
  local updateText = function()
    ui.title:setText("" .. storage[panelName].min .. "% <= hp >= " .. storage[panelName].max .. "%")  
  end
 
  ui.scroll1.onValueChange = function(scroll, value)
    storage[panelName].min = value
    updateText()
  end
  ui.scroll2.onValueChange = function(scroll, value)
    storage[panelName].max = value
    updateText()
  end
  ui.bpId.onItemChange = function(widget)
    storage[panelName].bpId = widget:getItemId()
  end
 
  ui.scroll1:setValue(storage[panelName].min)
  ui.scroll2:setValue(storage[panelName].max)
  ui.bpId:setItemId(storage[panelName].bpId)
end

local defaultAmulet = nil
macro(100, "SSA", function()
  if hppercent() <= storage["ssa"].min and (getNeck() == nil or getNeck():getId() ~= 3081) then
    if getNeck() ~= nil and defaultAmulet == nil then
      defaultAmulet = getNeck():getId()
    end
    for _, container in pairs(getContainers()) do
      for _, item in ipairs(container:getItems()) do
        containerItem = container:getContainerItem():getId()
        if containerItem == storage["ssa"].bpId then
          if item:getId() == 3081 then
            moveToSlot(item, SlotNeck)
            delay(200)
            return
          end
        end
      end
    end
    if defaultAmulet ~= nil or (getNeck() ~= nil and getNeck():getId() ~= defaultAmulet) then
      amulet = findItem(defaultAmulet)
      if amulet then
        moveToSlot(amulet, SlotNeck)
      end
    end
    isAlreadyOpen = false
    for i, container in pairs(getContainers()) do
      containerItem = container:getContainerItem():getId()
      if containerItem == storage["ssa"].bpId then
        isAlreadyOpen = true
        for _, item in ipairs(container:getItems()) do
          if item:isContainer() and item:getId() == storage["ssa"].bpId then
            g_game.open(item, container)
            delay(200)
            return
          end
        end
      end
    end
    if not isAlreadyOpen then
      for i, container in pairs(getContainers()) do
        for _, item in ipairs(container:getItems()) do
          if item:isContainer() and item:getId() == storage["ssa"].bpId then
            g_game.open(item)
            delay(400)
            return
          end
        end
      end
    end
  elseif hppercent() >= storage["ssa"].max and defaultAmulet ~= nil then
    if getNeck() == nil or (getNeck() ~= nil and getNeck():getId() ~= defaultAmulet) then
      amulet = findItem(defaultAmulet)
      if amulet then
        moveToSlot(amulet, SlotNeck)
      end
    end
  end
end, hpTab)
AddScrolls("ssa", hpTab)
addSeparator("sep", hpTab)

local defaultRing = nil
macro(100, "Equip E-Ring", function()
  if hppercent() <= storage["ering"].min and (getFinger() == nil or (getFinger():getId() ~= 3051 and getFinger():getId() ~= 3088)) then
    if getFinger() ~= nil and defaultRing == nil then
      defaultRing = getFinger()
    end
    ring = findItem(3051)
    findRing = false
    if ring then
      moveToSlot(ring, SlotFinger)
      delay(20)
    end

    if ring == nil then
      if defaultRing ~= nil or (getFinger() ~= nil and getFinger():getId() ~= defaultRing:getId()) then
        ring = findItem(defaultRing:getId())
        if ring then
          moveToSlot(ring, SlotFinger)
        end
      end
      findRing = true
    end

    if findRing then
      isAlreadyOpen = false
      for i, container in pairs(getContainers()) do
        containerItem = container:getContainerItem():getId()
        if containerItem == storage["ering"].bpId then
          isAlreadyOpen = true
          for _, item in ipairs(container:getItems()) do
            if item:isContainer() and item:getId() == storage["ering"].bpId then
              g_game.open(item, container)
              delay(30)
              return
            end
          end
        end
      end
      if not isAlreadyOpen then
        for i, container in pairs(getContainers()) do
          for _, item in ipairs(container:getItems()) do
            if item:isContainer() and item:getId() == storage["ering"].bpId then
              g_game.open(item)
              delay(40)
              return
            end
          end
        end
      end
    end
  elseif hppercent() >= storage["ering"].max and defaultRing ~= nil then
    if getFinger() == nil or (getFinger():getId() ~= defaultRing:getId()) then
      ring = findItem(defaultRing:getId())
      if ring then
        moveToSlot(ring, SlotFinger)
      end
    end
  end
end, hpTab)
AddScrolls("ering", hpTab)
addSeparator("sep", hpTab)

UI.Separator(toolsTab);

function combarScript(parent)
  local panelName = "combarScriptPanel"

  -- Caso não exista ainda, inicializamos a tabela de armazenamento
  if not storage[panelName] then
    storage[panelName] = {}
  end

  -- Macro que dispara a cada 1000ms (1s)
  macro(1000, function()
    if not storage[panelName].enabled then
      return
    end
    -- Desliga cave/target se quiser igual ao comboScript
    -- CaveBot.setOff()
    TargetBot.setOff()

    say("!combar")  -- executa o comando para usar as poções

    -- Religa depois de 5s (opcional, igual ao comboScript)
    schedule(5000, function()
      CaveBot.setOn()
      TargetBot.setOn()
    end)

    -- Aguarda 31 minutos para repetir (31*60*1000 = 1860000 ms)
    delay((31 * 60 * 1000) - 1000)
  end)
end

combarScript(toolsTab)


function comboScript(parent)
  if not parent then
    parent = panel
  end
 
  local panelName = "comboScriptPanel"
 
  local ui = setupUI([[
SixRowsItems < Panel
  height: 50
  margin-top: 2
  
  BotItem
    id: item1
    anchors.top: parent.top
    anchors.left: parent.left
  BotItem
    id: item2
    anchors.top: prev.top
    anchors.left: prev.right
    margin-left: 2
  BotItem
    id: item3
    anchors.top: prev.top
    anchors.left: prev.right
    margin-left: 2
  BotItem
    id: item4
    anchors.top: prev.top
    anchors.left: prev.right
    margin-left: 2
  BotItem
    id: item5
    anchors.top: prev.top
    anchors.left: prev.right
    margin-left: 2

Panel
  height: 80

  SmallBotSwitch
    id: title
    anchors.left: parent.left
    anchors.right: parent.right
    anchors.top: parent.top
    text-align: center

  HorizontalScrollBar
    id: scroll1
    anchors.left: title.left
    anchors.right: title.right
    anchors.top: title.bottom
    margin-right: 2
    margin-top: 2
    minimum: 1
    maximum: 90
    step: 1

  SixRowsItems
    id: items
    anchors.left: parent.left
    anchors.right: parent.right
    anchors.top: prev.bottom  
  ]], parent)
  ui:setId(panelName)
 
  if not storage[panelName] then
    storage[panelName] = {
      time = 61
    }
  end
 
  local updateText = function()
    ui.title:setText("Use every " .. storage[panelName].time .. " minutes")  
  end
 
  ui.scroll1.onValueChange = function(scroll, value)
    storage[panelName].time = value
    updateText()
  end
 
  ui.scroll1:setValue(storage[panelName].time)
 
  ui.title:setOn(storage[panelName].enabled)
  ui.title.onClick = function(widget)
    storage[panelName].enabled = not storage[panelName].enabled
    widget:setOn(storage[panelName].enabled)
  end
 
  if type(storage[panelName].items) ~= 'table' then
    storage[panelName].items = {
      11455, 10316, 10306, 10293, 9650, 11454, 3726, 9642, 3215, 13202,
      13203, 13204, 9641, 13435, 13436, 13437, 13273, 13274, 13275, 13513,
      13220, 13507, 13508
    }
  end
 
  for i=1,5 do
    ui.items:getChildByIndex(i).onItemChange = function(widget)
      storage[panelName].items[i] = widget:getItemId()
    end
    ui.items:getChildByIndex(i):setItemId(storage[panelName].items[i])    
  end
 
  macro(1000, function()
    if not storage[panelName].enabled then
      return
    end
    CaveBot.setOff()
    -- TargetBot.setOff()
    if #storage[panelName].items > 0 then
      timeOut = 5000
      for _, itemToUse in pairs(storage[panelName].items) do
        schedule(timeOut, function()
          use(itemToUse)
        end)
        timeOut = timeOut + 500
      end
    end
    schedule(timeOut + 5000, function()
      CaveBot.setOn()
      TargetBot.setOn()
    end)
    delay((storage[panelName].time * 60000) - 1000)
  end)
end

comboScript(toolsTab)

-- open Backpacks when reconnect
containers = getContainers()
if #containers < 1 and containers[0] == nil then
  bpItem = getBack()
  if bpItem ~= nil then
    g_game.open(bpItem)
  end
  say("!bless")
end

macro(10000, "Anti Idle",  function()
  local oldDir = direction()
  turn((oldDir + 1) % 4)
  schedule(1000, function()
    turn(oldDir)
  end)
end)

local mineableIds = {
  7807
}
mineMacro = nil
local lastSwitch = now
local switchInterval = 1000 * 60 * 60 * 2 -- 2 horas em milissegundos
local mineThing = nil
local lastActive = false
local lastPosition = nil -- track last mining position

mineMacro = macro(10, "Mine", function()
  -- Check if macro state changed or position changed significantly
  if mineMacro:isOn() ~= lastActive or 
     (lastPosition and getDistanceBetween(pos(), lastPosition) > 10) then
    mineThing = nil -- Reset mineThing when toggling or position changed
    lastActive = mineMacro:isOn()
    lastPosition = pos() -- Update last position
  end

  -- Return if macro is off
  if not mineMacro:isOn() then
    return
  end

  if mineThing == nil then
    tiles = g_map.getTiles(posz())
    randomTile = tiles[math.random(1,#tiles)]
    if not autoWalk(randomTile:getPosition(), 10, {ignoreNonPathable=true, marginMin=1, marginMax=2}) 
       or getDistanceBetween(pos(), randomTile:getPosition()) > 4 then
      return
    end
    for _, thing in ipairs(randomTile:getThings()) do
      for _,mineableId in ipairs(mineableIds) do
        if thing:getId() == mineableId then
          mineThing = thing
          lastPosition = pos() -- Save position where we found mineable
          return
        end
      end
    end
  else
    useWith(3456, mineThing)
  end
end)
-- Criar um macro separado para controlar a alternância
macro(1000, "Switch Mine/Cave", function()
  if now - lastSwitch >= switchInterval then
    if mineMacro:isOn() then
      print("Desligando Mine e Ligando Cavebot")
      mineMacro:setOff()
      schedule(500, function() -- pequeno delay para garantir
        CaveBot.setOn(true)
      end)
    else
      print("Desligando Cavebot e Ligando Mine")
      CaveBot.setOff(true)
      schedule(500, function() -- pequeno delay para garantir
        mineMacro:setOn()
      end)
    end
    lastSwitch = now
  end
end)

-- Inicia o Mine ligado
-- mineMacro:setOn()
