
-- Detector de Vocação
storage.PlayerVocation = storage.PlayerVocation or {
  id = nil,
  name = nil,
  detected = false
}
PlayerVocation = storage.PlayerVocation

setDefaultTab("Main")
UI.Separator()
local vocationPanelName = "vocationDetector"
local ui = setupUI([[
Panel
  height: 55
  top: 30
  Button
    id: detectBtn
    anchors.top: prev.bottom
    margin-left: 2
    margin-right: 2
    height: 17
    size: 171 17
    text: Auto Detect

  Button
    id: 1
    anchors.top: prev.bottom
    anchors.left: parent.left
    text: Knight
    margin-right: 2
    margin-top: 4
    size: 55 17

  Button
    id: 2
    anchors.verticalCenter: prev.verticalCenter
    anchors.left: prev.right
    text: Mage
    margin-left: 4
    size: 55 17
    
  Button
    id: 3
    anchors.verticalCenter: prev.verticalCenter
    anchors.left: prev.right
    text: Paladin
    margin-left: 4
    size: 55 17
]])
ui:setId(vocationPanelName)

-- Variáveis para controlar detecção
local isDetecting = false
local detectionTimeout = 0

-- Função para atualizar cores dos botões
local function updateButtonColors()
  ui[1]:setColor("white")
  ui[2]:setColor("white")
  ui[3]:setColor("white")
  
  if PlayerVocation.detected then
    if PlayerVocation.name == "Knight" then
      ui[1]:setColor("green")
    elseif PlayerVocation.name == "Mage" or PlayerVocation.name == "Sorcerer" or PlayerVocation.name == "Druid" then
      ui[2]:setColor("green")
    elseif PlayerVocation.name == "Paladin" then
      ui[3]:setColor("green")
    end
  end
end

-- Função para definir vocação
local function setVocation(name, id)
  storage.PlayerVocation.name = name
  storage.PlayerVocation.id = id
  storage.PlayerVocation.detected = true
  PlayerVocation = storage.PlayerVocation

  updateButtonColors()
  print("=== VOCATION SET ===")
  print("Name: " .. name .. " (ID: " .. id .. ")")

  whiteInfoMessage("Vocacao detectada: " .. name .. 
  "\nPor favor, reinicie o bot para garantir funcionamento.")
end

-- Função para detectar vocação
local function detectVocation()
  if isDetecting then return end
  
  isDetecting = true
  detectionTimeout = 0
  ui.detectBtn:setText("Detecting...")
  ui.detectBtn:setEnabled(false)
  
  print("Auto-detecting vocation...")
  g_game.look(player)
end

-- Callback para detecção automática
onTextMessage(function(mode, text)
  if not isDetecting then return end

  local vocName = nil
  local vocId = nil
  
  if text:lower():find("knight") then
    vocName = "Knight"
    vocId = 1
  elseif text:lower():find("paladin") then
    vocName = "Paladin"
    vocId = 3
  elseif text:lower():find("sorcerer") then
    vocName = "Sorcerer"
    vocId = 2
  elseif text:lower():find("druid") then
    vocName = "Druid"
    vocId = 2
  end
  
  if vocName then
    setVocation(vocName, vocId)
    ui.detectBtn:setText("Re-detect")
    ui.detectBtn:setEnabled(true)
    isDetecting = false
    print("Vocation detected: " .. vocName)
  end
end)

-- Timeout para detecção
macro(200, function()
  if isDetecting then
    detectionTimeout = detectionTimeout + 200
    if detectionTimeout >= 5000 then
      ui.detectBtn:setText("Auto Detect")
      ui.detectBtn:setEnabled(true)
      isDetecting = false
      print("Detection timeout - try manual selection")
    end
  end
end)

-- Eventos dos botões
ui.detectBtn.onClick = function()
  detectVocation()
end

ui[1].onClick = function() -- Knight
  isDetecting = false
  setVocation("Knight", 1)
end

ui[2].onClick = function() -- Mage
  isDetecting = false
  setVocation("Mage", 2)
end

ui[3].onClick = function() -- Paladin
  isDetecting = false
  setVocation("Paladin", 3)
end

-- Funções globais
function getPlayerVocation()
  return PlayerVocation
end

function getVocationName()
  return PlayerVocation.name
end

function getVocationId()
  return PlayerVocation.id
end

function isVocationDetected()
  return PlayerVocation.detected
end

-- Inicialização
updateButtonColors()
print("=== VOCATION DETECTOR LOADED ===")

-- Auto-detecção na inicialização
if not PlayerVocation.detected then
  macro(1000, function()
    if not PlayerVocation.detected then
      detectVocation()
    end
    return false
  end)
else
  print("Saved vocation: " .. PlayerVocation.name)
  print("Saved vocation ID: " .. tostring(PlayerVocation.id))
  updateButtonColors()
end
