setDefaultTab("Main")

-- =========================
-- STORAGE
-- =========================
local panelName = "expPotion"

storage.expPotion = storage.expPotion or {
  intervalMinutes = 61,
  potions = {0, 0, 0, 0, 0},

  batchIndex = 0,
  nextUseTime = 0
}

local config = storage.expPotion



-- =========================
-- NORMALIZA STORAGE
-- =========================
config.intervalMinutes = tonumber(config.intervalMinutes) or 60
config.batchRunning = config.batchRunning == true
config.batchIndex = tonumber(config.batchIndex) or 1
config.nextActionTime = tonumber(config.nextActionTime) or 0
config.lastBatchTime = tonumber(config.lastBatchTime) or 0

-- =========================
-- SETUP BUTTON
-- =========================
local ui = setupUI([[
Panel
  height: 19
  Button
    id: setup
    anchors.left: parent.left
    anchors.right: parent.right
    height: 17
    text: Setup EXP Potions
]])
ui:setId(panelName)

-- =========================
-- SETUP WINDOW
-- =========================
local rootWidget = g_ui.getRootWidget()
local expWindow

if rootWidget then
  expWindow = UI.createWindow('ExpPotionWindow', rootWidget)
  expWindow:hide()

  expWindow.closeButton.onClick = function()
    expWindow:hide()
  end

  expWindow.timeScroll:setValue(config.intervalMinutes)
  expWindow.timeText:setText("Usar a cada: " .. config.intervalMinutes .. " min")

  expWindow.timeScroll.onValueChange = function(_, value)
    config.intervalMinutes = value
    expWindow.timeText:setText("Usar a cada: " .. value .. " min")
  end

  local potionsPanel = expWindow:getChildById('potionsPanel')
  for i = 1, 5 do
    local slot = potionsPanel:getChildById('potion' .. i)
    if slot then
      slot.onItemChange = function(widget)
        config.potions[i] = widget:getItemId()
      end
      slot:setItemId(config.potions[i])
    end
  end
end

ui.setup.onClick = function()
  expWindow:show()
  expWindow:raise()
  expWindow:focus()
end

-- =========================
-- MACRO PRINCIPAL (PADRÃO COMBOSCRIPT)
-- =========================
local expMacro = macro(1000, "EXP Potion Consumer", function()
  print("[EXP] Usando EXP potions")

  local delayTime = 0
  for _, itemId in ipairs(config.potions) do
    if itemId and itemId > 0 then
      schedule(delayTime, function()
        use(itemId)
      end)
      delayTime = delayTime + 100
    end
  end

  -- trava a macro até o próximo ciclo
  delay((config.intervalMinutes * 60000) - 1000)
end)





-- =========================
-- ON / OFF DA MACRO
-- =========================
expMacro.onToggle = function(state)
  if state then
    print("[EXP] Macro ligada → usando potions agora")
    config.batchIndex = 1
    config.nextUseTime = 0
  else
    -- ao desligar, zera tudo
    config.batchIndex = 0
    config.nextUseTime = 0
  end
end

UI.Separator()
